/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.sequence;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.util.sequence.BasedSequence;
import icyllis.flexmark.util.sequence.SegmentedSequence;
import icyllis.flexmark.util.sequence.SequenceUtils;
import icyllis.flexmark.util.sequence.builder.IBasedSegmentBuilder;
import icyllis.flexmark.util.sequence.builder.ISegmentBuilder;
import icyllis.flexmark.util.sequence.builder.SegmentedSequenceStats;
import icyllis.flexmark.util.sequence.builder.tree.Segment;
import icyllis.flexmark.util.sequence.builder.tree.SegmentTree;
import icyllis.flexmark.util.sequence.builder.tree.SegmentTreeRange;

public final class SegmentedSequenceTree
extends SegmentedSequence {
    private final SegmentTree segmentTree;
    private final int startIndex;
    private final int startPos;
    private final int endPos;
    private final ThreadLocal<Cache> cache = new ThreadLocal();

    private SegmentedSequenceTree(BasedSequence baseSeq, int startOffset, int endOffset, int length, @NotNull SegmentTree segmentTree) {
        super(baseSeq, startOffset, endOffset, length);
        this.segmentTree = segmentTree;
        this.startIndex = 0;
        this.startPos = 0;
        this.endPos = segmentTree.size();
    }

    private SegmentedSequenceTree(BasedSequence baseSeq, @NotNull SegmentTree segmentTree, @NotNull SegmentTreeRange subSequenceRange) {
        super(baseSeq, subSequenceRange.startOffset, subSequenceRange.endOffset, subSequenceRange.length);
        this.segmentTree = segmentTree;
        this.startIndex = subSequenceRange.startIndex;
        this.startPos = subSequenceRange.startPos;
        this.endPos = subSequenceRange.endPos;
    }

    @NotNull
    private Cache getCache(int index) {
        Cache cache = this.cache.get();
        if (cache == null || cache.segment.notInSegment(index + this.startIndex)) {
            Segment segment = this.segmentTree.findSegment(index + this.startIndex, this.startPos, this.endPos, this.baseSeq, cache == null ? null : cache.segment);
            assert (segment != null);
            cache = new Cache(segment, segment.getCharSequence(), this.startIndex);
            this.cache.set(cache);
        }
        return cache;
    }

    @Nullable
    private Segment getCachedSegment() {
        Cache cache = this.cache.get();
        return cache == null ? null : cache.segment;
    }

    @Override
    public int getIndexOffset(int index) {
        if (index == this.length) {
            Cache cache = this.getCache(index - 1);
            CharSequence charSequence = cache.chars;
            if (charSequence instanceof BasedSequence) {
                return ((BasedSequence)charSequence).getIndexOffset(cache.charIndex(index));
            }
            return -1;
        }
        SequenceUtils.validateIndexInclusiveEnd(index, this.length());
        Cache cache = this.getCache(index);
        CharSequence charSequence = cache.chars;
        if (charSequence instanceof BasedSequence) {
            return ((BasedSequence)charSequence).getIndexOffset(cache.charIndex(index));
        }
        return -1;
    }

    @Override
    public void addSegments(@NotNull IBasedSegmentBuilder<?> builder) {
        this.segmentTree.addSegments(builder, this.startIndex, this.startIndex + this.length, this.startOffset, this.endOffset, this.startPos, this.endPos);
    }

    @Override
    @NotNull
    public SegmentTree getSegmentTree() {
        return this.segmentTree;
    }

    @Override
    public char charAt(int index) {
        SequenceUtils.validateIndex(index, this.length());
        return this.getCache(index).charAt(index);
    }

    @Override
    @NotNull
    public BasedSequence subSequence(int startIndex, int endIndex) {
        if (startIndex == 0 && endIndex == this.length) {
            return this;
        }
        SequenceUtils.validateStartEnd(startIndex, endIndex, this.length());
        SegmentTreeRange subSequenceRange = this.segmentTree.getSegmentRange(startIndex + this.startIndex, endIndex + this.startIndex, this.startPos, this.endPos, this.baseSeq, this.getCachedSegment());
        return new SegmentedSequenceTree(this.baseSeq, this.segmentTree, subSequenceRange);
    }

    public static SegmentedSequenceTree create(@NotNull BasedSequence baseSeq, ISegmentBuilder<?> builder) {
        SegmentedSequenceStats stats;
        SegmentTree segmentTree = SegmentTree.build(builder.getSegments(), builder.getText());
        if (baseSeq.anyOptions(F_COLLECT_SEGMENTED_STATS) && (stats = (SegmentedSequenceStats)baseSeq.getOption(SEGMENTED_STATS)) != null) {
            stats.addStats(builder.noAnchorsSize(), builder.length(), segmentTree.getTreeData().length * 4 + segmentTree.getSegmentBytes().length);
        }
        return new SegmentedSequenceTree(baseSeq.getBaseSequence(), builder.getStartOffset(), builder.getEndOffset(), builder.length(), segmentTree);
    }

    private static class Cache {
        @NotNull
        final Segment segment;
        @NotNull
        final CharSequence chars;
        final int indexDelta;

        public Cache(@NotNull Segment segment, @NotNull CharSequence chars, int startIndex) {
            this.segment = segment;
            this.chars = chars;
            this.indexDelta = startIndex - segment.getStartIndex();
        }

        public char charAt(int index) {
            return this.chars.charAt(index + this.indexDelta);
        }

        public int charIndex(int index) {
            return index + this.indexDelta;
        }
    }
}

